:: version 3.0 RisingWorld Unity Server Installer By Yahgiggle yahgiggle@gmail.com
:: settings example 
:: Set the drive example Serverdrive=C or Serverdrive=D or Serverdrive=E default C drive
Set Serverdrive=C
:: Set the folder example ServerFolder=RW-Server or ServerFolder=Myservers\test\whatever
Set ServerFolder=RW\Unity
:: set the hard reboot and backup time interval between reboots, time in seconds default 24hours
Set Reboot=86400
:: set the update time interval between looking for updates in seconds default every 5min 
Set Update=300
:: set the drive letter for the backup folder
Set BackupDrive=C
:: set the folder name for the Backups to be backuped too 
Set BackupFolder=RW-Backups\Unity
:: set the lenth of time in days a backup is stored on the drive before its deleted default 30days
set BackupStored=30




:: UIDs of server admins (separated by semicolon)
set Server_Admins=76561198018554331
:: Folder where the game stores backups. If blank, the game does not create any backups
set Server_BackupFolder=Backups
:: If true, the console window gets cleared on startup
set Server_ClearConsole=True
:: If true, the server.properties file will not include comments
set Server_ConfigNoComments=False
:: Optional contact mail address or website (where players may contact you)
set Server_Contact=
:: Relative path to an optional server header image (shown in server browser if user selects the server)
set Server_CustomHeaderImage=
:: Determines after how many days old server logs should be deleted. -1 to keep all logs
set Server_DeleteOldLogsDays=7
:: Optional server description (max 4096 characters). Visible in server browser (when player selects a server)
set Server_Description=Server installed using yahgiggles auto server installer
:: If true, the server will check if any of the server ports (UDP and TCP) are already in use
set Server_EnablePortCheck=True
:: Server target framerate (only affects the main thread). Default: 60
set Server_Framerate=60
:: If true, the server process listens for direct console input
set Server_Input=True
:: Server IP. Leave blank if you want the server to bind to all addresses
set Server_IP=
:: If true, the server creates log files in the 'Logs' subfolder
set Server_Logs=True
:: Server name (shows up in server list)
set Server_Name=RisingWorld
:: Server password. If set, users are prompted to enter the pw to join the server. Leave blank for no pw
set Server_Password=
:: Server port (TCP and UDP)
set Server_Port=4255
:: If true, the server performs an actual restart if the "restart" command is issued. Else it just shuts the server down
set Server_RestartEnabled=True
:: Optional short server name (max 32 characters). Leave blank to use regular server name
set Server_ShortName=
:: If true, the server blocks all players (UID) who are blacklisted ("blacklist" file in server dir)
set Server_UseBlacklist=False
:: If true, the server ensures that no player uses a reserved name (unless his UID matches)
set Server_UseReservedNames=False
:: If true, the server only accepts players (UID) who are whitelisted ("whitelist" file in server dir)
set Server_UseWhitelist=False
:: Determines whether or not the server should be visible in the server list (remember to change the server name)
set Server_Visible=True
:: Determines if the integrated webserver should be started. Required for RCON and queries
set Server_WebserverEnabled=True
:: Number of worker threads for integrated webserver. Default: 2
set Server_WebserverThreads=2

:::: WORLD SETTINGS

:: Default world game mode (only used when a new world is created). Either "Survival" or "Creative"
set World_GameMode=Survival
:: Name of the world which should be loaded (if it does not exist, it will be created)
set World_Name=RisingWorld Server
:: If false, the game will no longer save world changes
set World_SaveWorld=True
:: Seed that's used for world creation (only when a new world is created). Blank for random seed
set World_Seed=

:::: GENERAL SETTINGS

:: Determines if the global chat should be active
set Settings_ChatEnabled=True
:: If true, emojis will be shown in chat (depending on player permission)
set Settings_ChatShowEmojis=True
:: Amount of seconds until an unused chunk gets disposed. Low values reduce memory consumption, high values improve performance
set Settings_ChunkLifeSpan=60
:: Amount of chunk worker threads. Set to 0 for automatic assignment
set Settings_ChunkWorkerThreads=0
:: Time in seconds until dead bodies despawn. Default: 1800 (30 minutes)
set Settings_DeadBodyDespawnTime=1800
:: Determines after how many days old world event entries should be deleted. -1 to keep all entries
set Settings_DeleteWorldEventLogsDays=7
:: Game mode (0 = survival, 1 = creative)
set Settings_GameMode=0
:: If true, floating objects (like furniture) break under certain circumstances
set Settings_GravityAffectsObjects=True
:: If true, floating plants break under certain circumstances
set Settings_GravityAffectsPlants=True
:: If too many illegal states are detected for a player, he will be kicked from the server
set Settings_IllegalStateLimit=100
:: Time in seconds until a dropped item despawns
set Settings_ItemDespawnTime=600
:: If true, player world events (e.g. place or remove elements or terrain) will be tracked and logged
set Settings_LogWorldEvents=True
:: Maximum number of online players on the server
set Settings_MaxPlayers=64
:: Factor to modify the duration it takes to smelt ores. Default is 1. If you set it to 0.5, smelting takes half the time etc.
set Settings_OreSmeltingDurationFactor=0.2
:: Set this if you want to override the deep underground location name ("Deep Underground")
set Settings_OverrideDeepUndergroundLocationName=
:: Set this if you want to override the default location name ("Wilderness")
set Settings_OverrideDefaultLocationName=
:: Set this if you want to override the hell location name ("Hell")
set Settings_OverrideHellLocationName=
:: Set this if you want to override the orbit location name ("Orbit")
set Settings_OverrideOrbitLocationName=
:: Set this if you want to override the underground location name ("Underground")
set Settings_OverrideUndergroundLocationName=
:: When spawning several world items at once, the server tries to merge them (performance reasons) if set to true
set Settings_PackWorldItemStacks=False
:: Determines if peaceful mode should be active, i.e. enemies do not attack (unless provoked)
set Settings_PeacefulMode=False
:: If true, the player list (i) will show the distance to other players
set Settings_PlayerListShowDistance=True
:: If true, the player list (i) will show the permission group of other players
set Settings_PlayerListShowPermissionGroup=True
:: If true, the player list (i) will show the total playtime of other players
set Settings_PlayerListShowPlayTime=True
:: Determines how many "undo" steps are tracked per player
set Settings_PlayerUndoSteps=10
:: Determines how long (seconds) an undo step is valid
set Settings_PlayerUndoTime=300
:: If true, this server is advertised as PvE server (this alone does not affect the gameplay)
set Settings_PvE=True
:: If true, this server is advertised as PvP server (this alone does not affect the gameplay)
set Settings_PvP=True
:: If true, general messages (time of day or weather changed) will show up in the chat
set Settings_ShowGeneralMessages=True
:: Determines how long the current location should be shown to the player (in seconds). Set -1 to always show the location
set Settings_ShowLocationDuration=5
:: If true, all players will be notified when a player connects to the server
set Settings_ShowPlayerConnectMessage=True
:: If true, all players will be notified when a player dies
set Settings_ShowPlayerDeathMessage=True
:: If true, all players will see why a player died (only if ShowPlayerDeathMessage is true)
set Settings_ShowPlayerDeathMessageReason=True
:: If true, all players will be notified when a player leaves the server
set Settings_ShowPlayerDisconnectMessage=True
:: If true, a restart reminder will be sent to all admins if the server is running for more than 24 hours
set Settings_ShowRestartReminder=True
:: If true, chests will spawn all their content as world items if a player breaks them. May have performance implications
set Settings_SpawnChestItemsOnDestroy=True
:: Player spawn protection. Newly spawned players won't get attacked by npcs during the spawn protection. Default: 5 (seconds)
set Settings_SpawnProtection=10
:: Initial weather effect (e.g. "fog", "rain" etc). Leave blank for default weather
set Settings_StartWeather=
:: Duration (real time minutes) of one ingame day. Default: 60 (minutes)
set Settings_TimeDuration=120
:: Determines whether or not weather is enabled. If false, the server never changes weather automatically
set Settings_WeatherEnabled=True

:::: DATABASE SETTINGS

:: If true, the database runs in RAM (faster) and is only stored periodically on disc. Increases memory usage
set Database_InMemory=True
:: When using memory database, it's periodically saved to disc. Change the save interval (seconds) with this value (default: 60)
set Database_InMemoryBackupInterval=10
:: Sets the journal mode. It's recommended to use WAL. 0 = off, 1 = memory, 2 = delete, 3 = truncate, 4 = persist, 5 = WAL (default)
set Database_JournalMode=5
:: Synchronous flag. 0 = off, 1 = normal (default), 2 = full
set Database_SynchronousMode=1

:::: RCON SETTINGS

:: Only set this to true if you want to use a custom RCON tool (this disables the built-in RCON tool)
set RCON_APIOnly=False
:: Determines whether or not the RCON tool should be enabled
set RCON_Enabled=False
:: RCON IP. Leave blank to use default server IP
set RCON_IP=
:: Password required for RCON login. Min 6 characters (!)
set RCON_Password=12344321
:: RCON port (TCP)
set RCON_Port=4253
:: If set, only these IPs (separated by semicolon) may access the RCON tool
set RCON_WhitelistIP=

:::: PLUGIN SETTINGS

:: Determines whether or not plugins should be loaded. If false, no JVM will be created
set Plugins_Enabled=True
:: Max number of plugin errors until the server throws an exception
set Plugins_ErrorThreshold=10
:: Amount of heap memory (MB) for the Java VM. Default: 1024
set Plugins_Memory=1024

:::: PERMISSION SETTINGS

:: If true, server admins get full permissions, irrespective of their actual permission group
set Permissions_AdminsFullPermissions=True
:: Default permission group for new players. Leave blank to apply default permissions
set Permissions_DefaultNewPlayerPermissionGroup=